/* autogenerated by Processing revision 1293 on 2023-11-25 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import processing.sound.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class demosim extends PApplet {


SoundFile file;
SoundFile file2;

int mode = 0;

PFont titleFont;

PGraphics[] icons;
PImage[] tempIcons;
PGraphics bkg;
PGraphics undo;
PGraphics undo2;
int numIcons = 5;
int currentIcon = 0;
ColourButton[] colbuttons = new ColourButton[10];
int buttonSize = 20;
int currentColour;
int[] colours = {color(200,50,50),
                   color(255,100,50),
                   color(255,200,0),
                   color(100,200,50),
                   color(0,200,200),
                   color(0,100,200),
                   color(150,100,255),
                   color(255,100,200),
                   color(240,240,240),
                   color(40,40,40)};
int windowPosX = 100;
int windowPosY = 150;
int windowSize = 200;

PFont codeFont;
String[] code;
ArrayList<Character> displayedCharacters = new ArrayList<>();
int codeLine = 0;
int codeChar = 0;
boolean revealChar = false;
boolean codeComplete = false;

String currentName = "";
ArrayList<String> names = new ArrayList<String>();
int numGreetz = 10;
int currentGreet = 0;

int startTime;
int greetPosX;
int greetPosY;
int greetDirX = 1;
int greetDirY = 1;
float[] rndX;
float[] rndY;
float[] dirX;
float[] dirY;
float[] a;
float[] b;
int gradSteps = 8;
int[] bgCol1 = {100,50,100};
int[] bgCol2 = {60, 150, 240};


public void setup(){
  /* size commented out by preprocessor */;
  greetPosX = width/2;
  greetPosY = height/2;
  titleFont = createFont("Times New Roman Italic.ttf", 72);
  codeFont = createFont("ComicMono.ttf", 30);
  icons = new PGraphics[numIcons];
  tempIcons = new PImage[numIcons];
  rndX = new float[numIcons];
  rndY = new float[numIcons];
  dirX = new float[numIcons];
  dirY = new float[numIcons];
  bkg = createGraphics(800,600);
  undo = createGraphics(windowSize, windowSize);
  undo.beginDraw();
  undo.endDraw();
  undo2 = createGraphics(windowSize, windowSize);
  undo2.beginDraw();
  undo2.endDraw();
  surface.setTitle("MAKE YOUR OWN DEMO SIMULATOR");
  
  for(int i=0; i<numIcons; i++){
    // temp icons for debugging
    //tempIcons[i] = loadImage("icon" + i + ".png");
    icons[i] = createGraphics(windowSize, windowSize);
    icons[i].beginDraw();
    //icons[i].image(tempIcons[i],0,0);
    icons[i].endDraw();
    rndX[i] = PApplet.parseInt(random(20, width-windowSize-20));
    rndY[i] = PApplet.parseInt(random(20, height-windowSize-20));
    dirX[i] = random(-2,2);
    dirY[i] = random(-2,2);
  }
  
  a = new float[gradSteps];
  for(int i=0; i<gradSteps; i++){
    a[i] = 0.3f * i;
  }
  
  b = new float[3];
  for(int i=0; i<3; i++){
    b[i] = 0.3f * i;
  }  
  
  for(int i=0; i<colbuttons.length; i++){
    colbuttons[i] = new ColourButton(colours[i], 100 + i*(buttonSize+3), 400, buttonSize);
  }
  currentColour = colours[9];
  code = loadStrings("code.txt");
  file = new SoundFile(this, "strawberry.wav");
  file2 = new SoundFile(this, "demoooo.wav");
  file.loop();
}

public void draw(){
  switch(mode){
    case 0:
      titleScreen();
      break;
    case 1:
      paintScreen();
      break;
    case 2:
      codeScreen();
      break;
    case 3:
      greetzScreen();
      break;
    case 4:
      demoScreen();
      break;
  }
}

public void titleScreen(){
  background(200);
  noStroke();
  fill(40);
  textFont(titleFont);
  textSize(96);
  text("MAKE YOUR OWN\n FKN DEMO", 50, height*0.4f);
  textSize(40);
  fill(255,0,255);
  text("by pselodux", 100, height*0.7f);
  fill(255,255,0);
  text("PRESS ANY KEY", width/2, height*0.9f);
}

public void paintScreen(){
  background(200);
  noStroke();
  fill(40);
  textFont(titleFont);
  textSize(60);
  textAlign(LEFT, TOP);
  text("DRAW SOME STUFF!!", 20, 20);
  text(currentIcon+1 + " / " + numIcons, 500, 100);
  textSize(40);
  textAlign(RIGHT, BOTTOM);
  text("ENTER = NEXT IMAGE\nBACKSPACE or RIGHT CLICK = UNDO", width-20, height-20);
  fill(128);
  stroke(0);
  strokeWeight(1);
  rect(windowPosX, windowPosY, windowSize, windowSize);
  image(icons[currentIcon], windowPosX,windowPosY);
  if (mouseX >= windowPosX && mouseX <= windowPosX+windowSize &&
      mouseY >= windowPosY && mouseY <= windowPosY+windowSize){
        noStroke();
        fill(currentColour);
        circle(mouseX, mouseY, 5);
        if(mousePressed){
          if(mouseButton == LEFT){
            icons[currentIcon].beginDraw();
            icons[currentIcon].stroke(currentColour);
            icons[currentIcon].strokeWeight(5);
            icons[currentIcon].noFill();
            icons[currentIcon].line(mouseX-windowPosX, 
                                    mouseY-windowPosY, 
                                    pmouseX-windowPosX, 
                                    pmouseY-windowPosY);
            icons[currentIcon].endDraw();
          }
        }
  }
  for(int i=0; i<colbuttons.length; i++){
    colbuttons[i].display();
  }
}

public void codeScreen(){
  background(40);
  textFont(titleFont);
  textSize(60);
  textAlign(LEFT, TOP);
  fill(200);
  text("NOW WRITE YOUR CODE!!", 20, 20);
  textFont(codeFont);
  textSize(20);
  fill(0,255,0);
  
  for(Character c : displayedCharacters){
    text(c.value, c.x, c.y);
  }
  
  if(revealChar && codeLine < code.length){
    String line = code[codeLine];
    if(codeChar < line.length()){
      char currentCharValue = line.charAt(codeChar);
      displayedCharacters.add(new Character(currentCharValue, 20 + codeChar * 12, 100 + codeLine * 20));
      codeChar++;
    } else {
      codeLine++;
      codeChar = 0;
    }
    revealChar = false;
  }
  if(codeLine >= code.length){
   fill(255,0,0);
   textAlign(RIGHT, BOTTOM);
   textFont(titleFont);
   textSize(50);
   text("WOW! LOOKS SO GOOD!\nPRESS ENTER TO CONTINUE!!", width-20, height-20);
   codeComplete = true;
  }
}

public void greetzScreen(){
  background(200);
  textFont(titleFont);
  textAlign(LEFT, TOP);
  textSize(60);
  fill(40);
  text("NOW WRITE SOME NAMES\n OF PEEPZ 2 GREET!", 20, 20);
  textSize(30);
  if(currentGreet < numGreetz){
    text(currentGreet+1 + " / 10\n\n PRESS ENTER TO SUBMIT!!!", 100, 260);
    fill(240);
    stroke(0);
    strokeWeight(1);
    rect(100,200,600,50);
  } else {
    fill(255,0,0);
    text("WOW THOSE ARE SOME COOL PPL!!!\n\n PRESS ENTER TO WATCH DEMO!!", 100, 260);
  }
  
  textFont(codeFont);
  textSize(20);
  fill(40);
  text(currentName, 115, 215);
}

public void demoScreen(){
  background(bgCol1[0], bgCol1[1], bgCol1[2]);
  
  noStroke();
  for(int i=0; i<gradSteps; i++){
    fill(lerp(bgCol1[0],bgCol2[0],(sin(a[i])+1)/2),
         lerp(bgCol1[1],bgCol2[1],(sin(a[i])+1)/2),
         lerp(bgCol1[2],bgCol2[2],(sin(a[i])+1)/2));
    rect(0, i*height/gradSteps, width, height/gradSteps);
    a[i] += 0.05f;
  }
  
  textFont(titleFont);
  textSize(60);
  textAlign(CENTER, TOP);
  fill(lerp(100,240,(sin(b[0])+1)/2),
       lerp(100,240,(sin(b[1])+1)/2),
       lerp(100,240,(sin(b[2])+1)/2));
  for(int i=0; i<3; i++){
    b[i] += 0.03f * i;
  }
  
  text("GREETZ 2 " + names.get(currentGreet), greetPosX, greetPosY);
  int elapsedTime = millis() - startTime;
  if(elapsedTime > 2000){
    currentGreet = (currentGreet + 1) % names.size();
    startTime = millis();
  }
  greetPosX += greetDirX;
  greetPosY += greetDirY;
  if (greetPosX > width * 0.75f ||
      greetPosX < width * 0.25f){
        greetDirX *= -1;
      }
  if (greetPosY > height - 40 ||
      greetPosY < 0){
        greetDirY *= -1;
      }
      
  for(int i=0; i<numIcons; i++){
    if(rndX[i] > width - windowSize ||
       rndX[i] < 0){
       dirX[i] *= random(0.5f,2)*-1;
       dirX[i] = min(dirX[i], 2);
       rndX[i] = (constrain(rndX[i], 0, width-windowSize));
     }
    if(rndY[i] > height - windowSize ||
       rndY[i] < 0){
       dirY[i] *= random(0.5f,2)*-1;
       dirY[i] = min(dirY[i], 4);
       rndY[i] = (constrain(rndY[i], 0, width-windowSize));
     }
    image(icons[i], rndX[i], rndY[i]);
    rndX[i] = rndX[i] + dirX[i];
    rndY[i] = rndY[i] + dirY[i];
  }
  
}

public void mousePressed(){
  if(mouseButton == LEFT && mode == 0){
    mode = 1;
  }
  if(mouseButton == LEFT && mode == 1){
    updateUndo();
  }
  if(mouseButton == RIGHT && mode == 1){
    nextIcon();
  }
}

public void keyPressed(){
  if(mode == 3){
    if(key == ENTER){
      if(currentGreet < numGreetz){
        names.add(currentName);
        currentName = "";
        currentGreet++;
      } else {
        mode = 4;
        file.stop();
        file2.loop();
        currentGreet = 0;
        startTime = millis();
      }
    }
  }
  
  if(mode == 2){
    revealChar = true;
    if(codeComplete && key == ENTER){
      mode = 3;
    }
  }

  if(key == BACKSPACE && mode == 1){
    restoreUndo();
  }

  if(key == ENTER && mode == 1){
    nextIcon();
  }

  if(mode == 0){
    mode = 1;
  }
}

public void keyTyped(){
  if(mode == 3 && currentGreet <= numGreetz){
    if(key == BACKSPACE && currentName.length() > 0){
      currentName = currentName.substring(0,currentName.length() - 1);
    } else if (key != '\n') {
      currentName = currentName + key;
    }
  }
  
}

public void nextIcon(){
  //icons[currentIcon].save("icon" + currentIcon + ".png");
  currentIcon++;
  clearUndo();
  if(currentIcon >= numIcons){
    mode = 2;
  }
}

public void updateUndo(){
  undo.beginDraw();
  undo.clear();
  undo.copy(icons[currentIcon],0,0,windowSize,windowSize,0,0,windowSize,windowSize);
  undo.endDraw();
}

public void clearUndo(){
  undo.beginDraw();
  undo.clear();
  undo.endDraw();
}

public void restoreUndo(){
  undo2.beginDraw();
  undo2.clear();
  undo2.copy(icons[currentIcon],0,0,windowSize,windowSize,0,0,windowSize,windowSize);
  undo2.endDraw();
  icons[currentIcon].beginDraw();
  icons[currentIcon].clear();
  icons[currentIcon].copy(undo,0,0,windowSize,windowSize,0,0,windowSize,windowSize);
  icons[currentIcon].endDraw();
  undo.beginDraw();
  undo.clear();
  undo.copy(undo2,0,0,windowSize,windowSize,0,0,windowSize,windowSize);;
  undo.endDraw();
}

class ColourButton{
  int bCol;
  int xpos, ypos, size;
  ColourButton(int c, int x, int y, int s){
    bCol = c;
    xpos = x;
    ypos = y;
    size = s;
  }
  public void display(){
    stroke(0);
    strokeWeight(1);
    if(bCol == currentColour){
      strokeWeight(2);
    }
    fill(bCol);
    square(xpos, ypos, size);
    if(mouseX > xpos && mouseY > ypos
       && mouseX < xpos+size && mouseY < ypos +size){
         if(mousePressed){
           currentColour = bCol;
         }
       }
  }
}

class Character {
  char value;
  float x, y;
  
  Character(char value, float x, float y){
    this.value = value;
    this.x = x;
    this.y = y;
  }
}


  public void settings() { size(800, 600); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "demosim" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
